using System;
using System.Collections.Generic;
using System.Linq;
using HIPS.Web.Model.AssistedRegistration;
using HIPS.Web.Model.Common;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using HIPS.PcehrSchemas;

namespace HIPS.Web.Data.Hips
{
    // TODO: Remove refactor
    internal static class ModelConversions
    {
        public static Model.AssistedRegistration.Sex LoadSex(string sexCode, List<Model.AssistedRegistration.Sex> sexes)
        {
            return sexes.FirstOrDefault(s => s.Code == sexCode);
        }

        public static PersonDemographic LoadPersonDemographics(PatientWithoutPcehr patientWithoutPcehr, List<Model.AssistedRegistration.Sex> sexes)
        {
            if (!String.IsNullOrWhiteSpace(patientWithoutPcehr.DVANumber))
            {
                return new PersonDemographic(patientWithoutPcehr.FamilyName, patientWithoutPcehr.GivenNames, patientWithoutPcehr.DateOfBirth, LoadSex(patientWithoutPcehr.RegisteredSex.ToString(), sexes), patientWithoutPcehr.DVANumber);
            }
            else
            {
                return new PersonDemographic(patientWithoutPcehr.FamilyName, patientWithoutPcehr.GivenNames, patientWithoutPcehr.DateOfBirth, LoadSex(patientWithoutPcehr.RegisteredSex.ToString(), sexes), patientWithoutPcehr.MedicareNumber, patientWithoutPcehr.MedicareIrn);
            }
        }

        public static VerifiedIhi LoadIhi(PatientWithoutPcehr patientWithoutPcehr)
        {
            return new VerifiedIhi(patientWithoutPcehr.Ihi, patientWithoutPcehr.IhiStatusId, patientWithoutPcehr.IhiRecordStatusId, patientWithoutPcehr.DateLastValidated);
        }

        public static HospitalLocation LoadLocation(PatientWithoutPcehr patientWithoutPcehr, string hospitalCodeSystem)
        {
            return new HospitalLocation(patientWithoutPcehr.HospitalCode, hospitalCodeSystem, patientWithoutPcehr.Ward, patientWithoutPcehr.Room, patientWithoutPcehr.Bed);
        }

        public static ValidatedPatient LoadValidatedPatient(PatientWithoutPcehr patientWithoutPcehr, List<Model.AssistedRegistration.Sex> sexes, string hospitalCodeSystem)
        {
            PersonDemographic demographic = LoadPersonDemographics(patientWithoutPcehr, sexes);
            VerifiedIhi ihi = LoadIhi(patientWithoutPcehr);
            HospitalLocation location = LoadLocation(patientWithoutPcehr, hospitalCodeSystem);

            return new ValidatedPatient(demographic, ihi, location);
        }

        public static List<RegistrationDocumentConsent> LoadMedicareConsent(Dictionary<MedicareConsent, bool> medicareConsents)
        {
            List<RegistrationDocumentConsent> documentConsentList = new List<RegistrationDocumentConsent>();

            foreach (KeyValuePair<MedicareConsent, bool> medicareConsent in medicareConsents)
            {
                RegistrationDocumentConsentType consentType;
                if (!Enum.TryParse(medicareConsent.Key.Code, true, out consentType))
                {
                    throw new InvalidOperationException(String.Format("Unknown Medicare consent type specified (Id: {0}).", medicareConsent.Key.MedicareConsentId));
                }

                documentConsentList.Add(new RegistrationDocumentConsent { DocumentConsentType = consentType, DocumentConsentStatus = medicareConsent.Value ? RegistrationDocumentConsentStatus.ConsentGiven : RegistrationDocumentConsentStatus.ConsentNotGiven });
            }

            return documentConsentList;
        }

        public static RegistrationCorrespondenceChannel LoadIvcChannel(IvcDeliveryMethodDecision ivcDeliveryMethod)
        {
            RegistrationCorrespondenceChannel correspondenceChannel = new RegistrationCorrespondenceChannel();

            if (ivcDeliveryMethod == null)
            {
                correspondenceChannel.Channel = IvcCorrespondenceChannel.none; // TODO: Not selected?
                return correspondenceChannel;
            }

            // Determine channel type
            IvcCorrespondenceChannel channel;
            if (!Enum.TryParse(ivcDeliveryMethod.IvcDeliveryMethod.Code, true, out channel))
            {
                throw new InvalidOperationException(String.Format("Unknown IVC Delivery Method specified (Id: {0}).", ivcDeliveryMethod.IvcDeliveryMethod.IvcDeliveryMethodId));
            }

            // Determine endpoint destination
            switch (channel)
            {
                case IvcCorrespondenceChannel.email:
                    correspondenceChannel.email = ivcDeliveryMethod.ContactDestination;
                    break;
                case IvcCorrespondenceChannel.sms:
                    correspondenceChannel.phoneNumber = ivcDeliveryMethod.ContactDestination;
                    break;
                default:
                    break;
            }

            // Set Channel
            correspondenceChannel.Channel = channel;

            return correspondenceChannel;
        }

        public static EvidenceOfIdentityType LoadEvidenceOfIdentityType(IdentityVerificationMethod identityVerificationMethod)
        {
            // Determine identity evidence type
            EvidenceOfIdentityType evidenceType;
            if (!Enum.TryParse(identityVerificationMethod.Code, true, out evidenceType))
            {
                throw new InvalidOperationException(String.Format("Unknown Identity Verification Method specified (Id: {0}).", identityVerificationMethod.IdentityVerificationMethodId));
            }

            return evidenceType;
        }

        public static HIPS.PcehrDataStore.Schemas.Enumerators.IndigenousStatus LoadIndigenousStatus(Model.AssistedRegistration.IndigenousStatus indigenousStatus)
        {
            // Determine indigenous status
            HIPS.PcehrDataStore.Schemas.Enumerators.IndigenousStatus status;
            if (!Enum.TryParse(indigenousStatus.Code, true, out status))
            {
                throw new InvalidOperationException(String.Format("Unknown Indigenous Status specified (Code: {0}).", indigenousStatus.Code));
            }

            return status;
        }

        public static IhiStatus LoadIhiStatus(int ihiStatusId)
        {
            // Determine IHI status
            if (!Enum.IsDefined(typeof(IhiStatus), ihiStatusId))
            {
                throw new InvalidOperationException(String.Format("Unknown IHI Status specified (Id: {0}).", ihiStatusId));
            }

            return (IhiStatus)ihiStatusId;
        }

        public static IhiRecordStatus LoadIhiRecordStatus(int ihiRecordStatusId)
        {
            // Determine IHI record status
            if (!Enum.IsDefined(typeof(IhiRecordStatus), ihiRecordStatusId))
            {
                throw new InvalidOperationException(String.Format("Unknown IHI Record Status specified (Id: {0}).", ihiRecordStatusId));
            }

            return (IhiRecordStatus)ihiRecordStatusId;
        }

        public static SexEnumerator LoadSex(Model.AssistedRegistration.Sex sex)
        {
            // Determine IHI record status
            SexEnumerator sexValue;
            if (!Enum.TryParse(sex.Code, true, out sexValue))
            {
                throw new InvalidOperationException(String.Format("Unknown Sex value specified (Code: {0}).", sex.Code));
            }

            return sexValue;
        }

        public static HIPS.CommonSchemas.PatientIdentifier.ValidatedIhi LoadValidatedIhi(PersonDemographic registeredDemographics, VerifiedIhi verifiedIhi, Model.Common.Hospital hospital)
        {
            IhiStatus ihiStatus = LoadIhiStatus(verifiedIhi.IhiStatusId);
            IhiRecordStatus ihiRecordStatus = LoadIhiRecordStatus(verifiedIhi.IhiRecordStatusId);
            SexEnumerator sex = LoadSex(registeredDemographics.Sex);

            if (!registeredDemographics.DateOfBirth.HasValue)
            {
                throw new InvalidOperationException("No Date of Birth specified.");
            }

            return new HIPS.CommonSchemas.PatientIdentifier.ValidatedIhi(verifiedIhi.Ihi, ihiStatus, ihiRecordStatus, verifiedIhi.DateLastValidated, registeredDemographics.FamilyName, registeredDemographics.GivenName, registeredDemographics.DateOfBirth.Value, sex, hospital.HospitalFacilityCode, hospital.HospitalFacilityCodeSystem);
        }

        public static Demographic LoadDemographics(PersonDemographic demographics, Model.Common.Hospital hospital)
        {
            SexEnumerator sex = LoadSex(demographics.Sex);

            if (!demographics.DateOfBirth.HasValue)
            {
                throw new InvalidOperationException("No Date of Birth specified.");
            }

            if (!String.IsNullOrWhiteSpace(demographics.DvaFileNumber))
            {
                return new Demographic(demographics.FamilyName, demographics.GivenName, demographics.DateOfBirth.Value, sex, demographics.DvaFileNumber, hospital.HospitalFacilityCode, hospital.HospitalFacilityCodeSystem);
            }
            else
            {
                return new Demographic(demographics.FamilyName, demographics.GivenName, demographics.DateOfBirth.Value, sex, demographics.MedicareNumber, demographics.MedicareIrn.ToString(), hospital.HospitalFacilityCode, hospital.HospitalFacilityCodeSystem);
            }
        }
    }
}
